//--------- Gsap Text Split Animation Start---------//
gsap.registerPlugin(ScrollTrigger);

function debounce(func){
  var timer;
  return function(event){
    if(timer) clearTimeout(timer);
    timer = setTimeout(func,300,event);
  };
}

var mediaMatch = gsap.matchMedia();

//-------------------------------------------------------------------------------------------------------------------------------------//

function init() {
  // gsap.registerPlugin(ScrollTrigger);

  //--------- Gsap Text Fade Animation---------//
  $('.fadeIn').each(function (index) {
    let tlx = new gsap.timeline({ paused: true });
    tlx.from($(this), {
      opacity: 0,
      duration: 1,
      delay: 0.5,
      ease: 'sine.inOut',
      stagger: 2,
    });
    tlx.to($(this), {
      opacity: 1,
      duration: 1,
      delay: 0.5,
      ease: 'sine.inOut',
      stagger: 2,
    });

    ScrollTrigger.create({
      trigger: $(this),
      start: 'top bottom',
      onLeaveBack: () => {
        tlx.pause(0);
      },
    });

    ScrollTrigger.create({
      trigger: $(this),
      start: 'top 100%',
      onEnter: () => tlx.play(),
    });
  });

  $('.fadeInUp').each(function (index) {
    let tll = new gsap.timeline({ paused: true });
    tll.from($(this), {
      opacity: 0,
      yPercent: 20,
      duration: 1.5,
      ease: 'sine.inOut',
      stagger: 2,
    });

    tll.to($(this), {
      opacity: 1,
      yPercent: 0,
      duration: 1.5,
      ease: 'sine.inOut',
      stagger: 2,
    });
    ScrollTrigger.create({
      trigger: $(this),
      start: "top bottom",
      onLeaveBack: () => {
        tll.pause(0);
      },
    });
    ScrollTrigger.create({
      trigger: $(this),
      start: "top 80%",
      onEnter: () => tll.play(),
    });
  });
//--------- Gsap Text Fade Animation---------//
    gsap.utils.toArray('[txt-slide-up] > [text-split]').forEach(function (txt) {

      let typeSplit = new SplitType(txt, {
        types: 'words, chars',
        tagName: 'span',
      });

      // let els = txt.getElementsByClassName('char');
    let tl = new gsap.timeline({ paused: true });
    tl.from(typeSplit.chars, {
      yPercent: 110,
      duration: 1,
      ease: 'back.out(2)',
      stagger: {
        amount: 0.8,
        ease: 'power2.inout',
      },
    });

    ScrollTrigger.create({
      trigger: txt,
      toggleActions: "play none none reset",
      start: "top bottom",
      pinnedContainer: '.animation-container',
      markers:false,
      onLeaveBack: () => {
        tl.pause(0);
      },
    });

    ScrollTrigger.create({
      trigger: txt,
      toggleActions: "play none none reset",
      start: "top 80%",
      pinnedContainer: '.animation-container',
      // markers:true,
      onEnter: () => tl.play(),
    });
  })

  gsap.set('[txt-slide-up]', { opacity: 1 });
//--------- Gsap Text Split Animation End---------//


}

//-------------------------------------------------------------------------------------------------------------------------------------//


//--------- Gsap Swiper First Slider With Rolling Animation---------//
mediaMatch.add("(max-width: 767px)", () => {
  console.log("small screen");
});

mediaMatch.add("(min-width: 768px) and (max-width: 1439px)", () => {
  console.log("medium screen");
});

mediaMatch.add("(min-width: 1440px)", () => {
  console.log("bigger screen");
});

//--------- Gsap Swiper First Slider With Rolling Animation End---------//
// function killAll() {
//   ScrollTrigger.getAll().forEach((trigger) => trigger.kill())
//   init()
// }

// window.addEventListener("resize", debounce(function(e){
//   console.log("end of resizing")
//    killAll()
//  }));
 
 $(document).ready(function () {
  init();
 });

//-------------------------------------------------------------------------------------------------------------------------------------//


